<?php
/**
 * DokuWiki Plugin latestupdate (Syntax Component)
 *
 * @license GPL 2 http://www.gnu.org/licenses/gpl-2.0.html
 * @author  Donghua Gu <gudonghua@gmail.com>
 */

// must be run within Dokuwiki
if (!defined('DOKU_INC')) die();

if (!defined('DOKU_LF')) define('DOKU_LF', "\n");
if (!defined('DOKU_TAB')) define('DOKU_TAB', "\t");
if (!defined('DOKU_PLUGIN')) define('DOKU_PLUGIN',DOKU_INC.'lib/plugins/');

require_once(DOKU_PLUGIN.'syntax.php');
require_once(DOKU_INC.'inc/html.php');


class syntax_plugin_latestupdate_latestupdate extends DokuWiki_Syntax_Plugin {
    public function getType() {
        #return 'FIXME: container|baseonly|formatting|substition|protected|disabled|paragraphs';
        return 'substition';
    }

    public function getPType() {
        #return 'FIXME: normal|block|stack';
        return 'block';
    }

    public function getSort() {
        return 32;
    }


    public function connectTo($mode) {
        $this->Lexer->addSpecialPattern('<latestupdate>',$mode,'plugin_latestupdate_latestupdate');
//        $this->Lexer->addEntryPattern('<FIXME>',$mode,'plugin_latestupdate_latestupdate');
    }

//    public function postConnect() {
//        $this->Lexer->addExitPattern('</FIXME>','plugin_latestupdate_latestupdate');
//    }

    public function handle($match, $state, $pos, &$handler){
        $data = array();
        return $data;
    }

    public function render($mode, &$renderer, $data) {
        if($mode != 'xhtml') return false;
        $recent_changes = getRecents(0, 10);
        $html = "";
        $html .= '<ul>';
        foreach ($recent_changes as $recent) {
            $date = strftime("%Y-%m-%d",$recent['date']);
            $html .= ($recent['type']===DOKU_CHANGE_TYPE_MINOR_EDIT) ? '<li class="minor">' : '<li>';
            $html .= '<div class="li">';
            $html .= $date.' ';
            $html .= '<a href="'.wl($recent['id'],"do=diff").'">';
            $p = array();
            $p['src']    = DOKU_BASE.'lib/images/diff.png';
            $p['width']  = 15;
            $p['height'] = 11;
            $p['title']  = $lang['diff'];
            $p['alt']    = $lang['diff'];
            $att = buildAttributes($p);
            $html .= "<img $att />";
            $html .= '</a> ';

            $html .= '<a href="'.wl($recent['id'],"do=revisions").'">';
            $p = array();
            $p['src']    = DOKU_BASE.'lib/images/history.png';
            $p['width']  = 12;
            $p['height'] = 14;
            $p['title']  = $lang['btn_revs'];
            $p['alt']    = $lang['btn_revs'];
            $att = buildAttributes($p);
            $html .= "<img $att />";
            $html .= '</a> ';

            $html .= html_wikilink(':'.$recent['id'],NULL);
            // $html .= ' &ndash; '.htmlspecialchars($recent['sum']);
            $html .= ' <span class="user">';
            if($recent['user']){
              $html .= htmlspecialchars($recent['user']);
            }else{
              $html .= $recent['ip'];
            }
            $html .= '</span></div></li>';
          }
          $html .= '</ul>';
          $renderer->doc .= $html;
        return true;
    }
}

// vim:ts=4:sw=4:et:
